<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Recommendation extends Model 
{

    protected $table = 'recommendations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'responsible', 'longitude', 'latitude', 'comment');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

}